#include <iostream>
#include <fstream>
using namespace std;

typedef enum { red, black } Color;

/* red-black tree */
struct Node {
  Node *left;
  Node *right;
  Node *parent;
  Color color;
  int data;
};

/* raudonai-juodo medzio saknis*/
Node *root = NULL;

/* Creates an empty binary tree */
Node *RBEmpty(void) {
  return NULL;
}

void rotateLeft(Node *x) {
  /*  rotate node x to left */
  Node *y = x->right;
  /* establish x->right link */
  x->right = y->left;
  if (y->left != NULL)
    y->left->parent = x;
  /* establish y->parent link */
  if (y != NULL)
    y->parent = x->parent;
  if (x->parent) {
    if (x == x->parent->left)
      x->parent->left = y;
    else
      x->parent->right = y;
  } else {
      root = y;
    }
  /* link x and y */
  y->left = x;
  if (x != NULL)
    x->parent = y;
}

void rotateRight(Node *x) {
  /*  rotate node x to right  */
  Node *y = x->left;
  /* establish x->left link */
  x->left = y->right;
  if (y->right != NULL)
    y->right->parent = x;
  /* establish y->parent link */
  if (y != NULL)
    y->parent = x->parent;
  if (x->parent) {
    if (x == x->parent->right)
      x->parent->right = y;
    else
      x->parent->left = y;
  } else {
      root = y;
    }
  /* link x and y */
  y->right = x;
  if (x != NULL)
    x->parent = y;
}

void insertFixup(Node *x) {
  // maintain red-black tree balance
  // after inserting node x

  // check red-black properties
  while (x != root && x->parent->color == red) {
  // we have a violation
    if (x->parent == x->parent->parent->left) {
      Node *y = x->parent->parent->right;
      if (y != NULL && y->color == red) {
        // uncle is RED
        x->parent->color = black;
        y->color = black;
        x->parent->parent->color = red;
        x = x->parent->parent;
      } else {
          // uncle is BLACK
          if (x == x->parent->right) {
            // make x a left child
            x = x->parent;
            rotateLeft(x);
          }
          // recolor and rotate
          x->parent->color = black;
          x->parent->parent->color = red;
          rotateRight(x->parent->parent);
        }
    } else {
        // mirror image of above code
        Node *y = x->parent->parent->left;
        if (y != NULL && y->color == red) {
          x->parent->color = black;
          y->color = black;
          x->parent->parent->color = red;
          x = x->parent->parent;
        } else {
            if (x == x->parent->left) {
              x = x->parent;
              rotateRight(x);
            }
            x->parent->color = black;
            x->parent->parent->color = red;
            rotateLeft(x->parent->parent);
          }
      }
  }
  root->color = black;
}

Node *insertNode(int data) {
  Node *current, *parent, *x;
  /* randame kur iterpti nauja nari */
  current = root;
  parent = 0;
  while (current != NULL) {
    if (data == current->data) {
      current = root;
      return current;
    }
    parent = current;
    current = (data < current->data) ?
      current->left : current->right;
  }
  // sukuriam nauja nari
  x = new Node;
  x->data = data;
  x->parent = parent;
  x->left = NULL;
  x->right = NULL;
  x->color = red;
  // iterpiam nauja nari i medi
  if(parent) {
    if(data < parent->data)
      parent->left = x;
    else
      parent->right = x;
  } else {
      root = x;
    }
  insertFixup(x);
  return root;
}

int findNode(int data, Node *tree) {
  if(tree!=NULL) {
    if(data==tree->data)
      return (tree->data);
    if(data<tree->data)
      return findNode(data, tree->left);
    else
      return findNode(data, tree->right);
  }
  else return NULL;
}

Node* conjunction(Node *tree1, Node *tree2) {
  if (tree1 == NULL)
    return tree2;
  if (tree2 == NULL)
    return tree1;

  root = tree1;
  int nodeValue = tree2->data;
  tree1 = insertNode(nodeValue);
  conjunction(tree1, tree2->left);
  conjunction(tree1, tree2->right);
  return root;
}

Node* intersection(Node *tree, Node *tree1, Node *tree2) {
  root = tree;
  if ((tree1 == NULL) || (tree2 == NULL))
    return 0;
  int nodeValue = tree2->data;
  int tr = findNode(nodeValue, tree1);
  if (tr != NULL)
    tree = insertNode(nodeValue);
  intersection(tree,tree1, tree2->left);
  intersection(tree,tree1, tree2->right);
  return root;
}

void printTree(Node *tree) {
  if (tree->left != NULL){
    printTree(tree->left);
    cout << " ";
  }
  cout << tree->data;
  if (tree->right != NULL) {
    cout << " ";
    printTree(tree->right);
  }
}

int main() {
  Node *t1, *t2, *t_con, *t_int;
  ifstream inFile1, inFile2;
  int skaicius;

  cout << "Pirmas medis:" << endl;
  inFile1.open("Skaiciai1.txt");
  while (!inFile1.eof()) {
    inFile1 >> skaicius;
    t1 = insertNode(skaicius);
  }
  printTree(t1);
  cout << endl;
  inFile1.close();

  root = NULL;
  cout << "Antras medis:" << endl;
  inFile2.open("Skaiciai2.txt");
  while (!inFile2.eof()) {
    inFile2 >> skaicius;
    t2 = insertNode(skaicius);
  }
  printTree(t2);
  cout << endl;
  inFile2.close();

  t_int = RBEmpty();
  t_int = intersection(t_int, t1, t2);

  cout << "Aibiu sajunga: " << endl;
  t_con = conjunction(t1, t2);
  printTree(t_con);
  cout << endl;

  if (t_int != NULL) {
    cout << "Aibiu sankirta:" << endl;
    printTree(t_int);
  }
  else
    cout << "Aibiu sankirta yra tuscia " << endl;
  cout << endl;
  cin >> skaicius;
}

